/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.brush_shapes;

import com.moulberry.axiom.brush_shapes.BrushShape;
import com.moulberry.axiom.utils.Box;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public interface SphereBrushShape
extends BrushShape {
    public static SphereBrushShape create(int radius) {
        return new SimpleSphereBrushShape(radius);
    }

    public static SphereBrushShape create(int radiusX, int radiusY, int radiusZ) {
        if (radiusX == radiusY && radiusX == radiusZ) {
            return SphereBrushShape.create(radiusX);
        }
        return new SeparateSphereBrushShape(radiusX, radiusY, radiusZ);
    }

    public static SphereBrushShape create(int radiusX, int radiusY, int radiusZ, Quaternionf quaternionf) {
        if (radiusX == radiusY && radiusX == radiusZ) {
            return SphereBrushShape.create(radiusX);
        }
        if (BrushShape.isQuaternionIdentity(quaternionf)) {
            return SphereBrushShape.create(radiusX, radiusY, radiusZ);
        }
        return new RotatedSphereBrushShape(radiusX, radiusY, radiusZ, quaternionf);
    }

    public static final class SimpleSphereBrushShape
    implements SphereBrushShape {
        private final int maxRadiusSq;
        private final float invMaxRadiusSq;
        private final Box boundingBox;

        public SimpleSphereBrushShape(int radius) {
            this.maxRadiusSq = radius * radius + radius;
            this.invMaxRadiusSq = 1.0f / (float)this.maxRadiusSq;
            this.boundingBox = new Box(-radius, -radius, -radius, radius, radius, radius);
        }

        @Override
        public Box boundingBox() {
            return this.boundingBox;
        }

        @Override
        public boolean isInsideShape(int x, int y, int z) {
            return x * x + y * y + z * z <= this.maxRadiusSq;
        }

        @Override
        public float distanceSq(int x, int y, int z) {
            return x * x + y * y + z * z;
        }

        @Override
        public float sdfSq(int x, int y, int z) {
            return (float)(x * x + y * y + z * z) * this.invMaxRadiusSq;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleSphereBrushShape that = (SimpleSphereBrushShape)o;
            return this.maxRadiusSq == that.maxRadiusSq;
        }

        public int hashCode() {
            return this.maxRadiusSq;
        }
    }

    public static final class SeparateSphereBrushShape
    implements SphereBrushShape {
        private final float invMaxRadiusSqX;
        private final float invMaxRadiusSqY;
        private final float invMaxRadiusSqZ;
        private final Box boundingBox;

        public SeparateSphereBrushShape(int radiusX, int radiusY, int radiusZ) {
            this.boundingBox = new Box(-radiusX, -radiusY, -radiusZ, radiusX, radiusY, radiusZ);
            float invMaxRadiusSqX = 1.0f / (float)(radiusX * radiusX + radiusX);
            float invMaxRadiusSqY = 1.0f / (float)(radiusY * radiusY + radiusY);
            float invMaxRadiusSqZ = 1.0f / (float)(radiusZ * radiusZ + radiusZ);
            if (!Float.isFinite(invMaxRadiusSqX)) {
                invMaxRadiusSqX = Float.MAX_VALUE;
            }
            if (!Float.isFinite(invMaxRadiusSqY)) {
                invMaxRadiusSqY = Float.MAX_VALUE;
            }
            if (!Float.isFinite(invMaxRadiusSqZ)) {
                invMaxRadiusSqZ = Float.MAX_VALUE;
            }
            this.invMaxRadiusSqX = invMaxRadiusSqX;
            this.invMaxRadiusSqY = invMaxRadiusSqY;
            this.invMaxRadiusSqZ = invMaxRadiusSqZ;
        }

        @Override
        public Box boundingBox() {
            return this.boundingBox;
        }

        @Override
        public boolean isInsideShape(int x, int y, int z) {
            return (float)(x * x) * this.invMaxRadiusSqX + (float)(y * y) * this.invMaxRadiusSqY + (float)(z * z) * this.invMaxRadiusSqZ <= 1.0f;
        }

        @Override
        public float distanceSq(int x, int y, int z) {
            return x * x + y * y + z * z;
        }

        @Override
        public float sdfSq(int x, int y, int z) {
            return (float)(x * x) * this.invMaxRadiusSqX + (float)(y * y) * this.invMaxRadiusSqY + (float)(z * z) * this.invMaxRadiusSqZ;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SeparateSphereBrushShape that = (SeparateSphereBrushShape)o;
            if (Float.compare(that.invMaxRadiusSqX, this.invMaxRadiusSqX) != 0) {
                return false;
            }
            if (Float.compare(that.invMaxRadiusSqY, this.invMaxRadiusSqY) != 0) {
                return false;
            }
            return Float.compare(that.invMaxRadiusSqZ, this.invMaxRadiusSqZ) == 0;
        }

        public int hashCode() {
            int result = this.invMaxRadiusSqX != 0.0f ? Float.floatToIntBits(this.invMaxRadiusSqX) : 0;
            result = 31 * result + (this.invMaxRadiusSqY != 0.0f ? Float.floatToIntBits(this.invMaxRadiusSqY) : 0);
            result = 31 * result + (this.invMaxRadiusSqZ != 0.0f ? Float.floatToIntBits(this.invMaxRadiusSqZ) : 0);
            return result;
        }
    }

    public static final class RotatedSphereBrushShape
    implements SphereBrushShape {
        private final float invRadiusSqX;
        private final float invRadiusSqY;
        private final float invRadiusSqZ;
        private final Box boundingBox;
        private final Quaternionf quaternionf;
        private final Vector3f tempVector = new Vector3f();

        public RotatedSphereBrushShape(int radiusX, int radiusY, int radiusZ, Quaternionf quaternionf) {
            int minX = 0;
            int minY = 0;
            int minZ = 0;
            int maxX = 0;
            int maxY = 0;
            int maxZ = 0;
            Vector3f vector3f = new Vector3f();
            for (int x = -1; x <= 1; x += 2) {
                for (int y = -1; y <= 1; y += 2) {
                    for (int z = -1; z <= 1; z += 2) {
                        vector3f.set((float)(radiusX * x), (float)(radiusY * y), (float)(radiusZ * z));
                        quaternionf.transformInverse(vector3f);
                        if (vector3f.x < 0.0f) {
                            minX = Math.min(minX, (int)Math.floor(vector3f.x));
                        } else {
                            maxX = Math.max(maxX, (int)Math.ceil(vector3f.x));
                        }
                        if (vector3f.y < 0.0f) {
                            minY = Math.min(minY, (int)Math.floor(vector3f.y));
                        } else {
                            maxY = Math.max(maxY, (int)Math.ceil(vector3f.y));
                        }
                        if (vector3f.z < 0.0f) {
                            minZ = Math.min(minZ, (int)Math.floor(vector3f.z));
                            continue;
                        }
                        maxZ = Math.max(maxZ, (int)Math.ceil(vector3f.z));
                    }
                }
            }
            this.boundingBox = new Box(minX, minY, minZ, maxX, maxY, maxZ);
            this.quaternionf = quaternionf;
            float invRadiusSqX = 1.0f / (float)(radiusX * radiusX + radiusX);
            float invRadiusSqY = 1.0f / (float)(radiusY * radiusY + radiusY);
            float invRadiusSqZ = 1.0f / (float)(radiusZ * radiusZ + radiusZ);
            if (!Float.isFinite(invRadiusSqX)) {
                invRadiusSqX = Float.MAX_VALUE;
            }
            if (!Float.isFinite(invRadiusSqY)) {
                invRadiusSqY = Float.MAX_VALUE;
            }
            if (!Float.isFinite(invRadiusSqZ)) {
                invRadiusSqZ = Float.MAX_VALUE;
            }
            this.invRadiusSqX = invRadiusSqX;
            this.invRadiusSqY = invRadiusSqY;
            this.invRadiusSqZ = invRadiusSqZ;
        }

        @Override
        public Box boundingBox() {
            return this.boundingBox;
        }

        @Override
        public boolean isInsideShape(int x, int y, int z) {
            this.tempVector.set((float)x, (float)y, (float)z);
            this.quaternionf.transform(this.tempVector);
            float rx = this.tempVector.x;
            float ry = this.tempVector.y;
            float rz = this.tempVector.z;
            return rx * rx * this.invRadiusSqX + ry * ry * this.invRadiusSqY + rz * rz * this.invRadiusSqZ <= 1.0f;
        }

        @Override
        public float distanceSq(int x, int y, int z) {
            this.tempVector.set((float)x, (float)y, (float)z);
            this.quaternionf.transform(this.tempVector);
            float rx = this.tempVector.x;
            float ry = this.tempVector.y;
            float rz = this.tempVector.z;
            return rx * rx + ry * ry + rz * rz;
        }

        @Override
        public float sdfSq(int x, int y, int z) {
            this.tempVector.set((float)x, (float)y, (float)z);
            this.quaternionf.transform(this.tempVector);
            float rx = this.tempVector.x;
            float ry = this.tempVector.y;
            float rz = this.tempVector.z;
            return rx * rx * this.invRadiusSqX + ry * ry * this.invRadiusSqY + rz * rz * this.invRadiusSqZ;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RotatedSphereBrushShape that = (RotatedSphereBrushShape)o;
            if (Float.compare(that.invRadiusSqX, this.invRadiusSqX) != 0) {
                return false;
            }
            if (Float.compare(that.invRadiusSqY, this.invRadiusSqY) != 0) {
                return false;
            }
            if (Float.compare(that.invRadiusSqZ, this.invRadiusSqZ) != 0) {
                return false;
            }
            return this.quaternionf.equals((Object)that.quaternionf);
        }

        public int hashCode() {
            int result = this.invRadiusSqX != 0.0f ? Float.floatToIntBits(this.invRadiusSqX) : 0;
            result = 31 * result + (this.invRadiusSqY != 0.0f ? Float.floatToIntBits(this.invRadiusSqY) : 0);
            result = 31 * result + (this.invRadiusSqZ != 0.0f ? Float.floatToIntBits(this.invRadiusSqZ) : 0);
            result = 31 * result + this.quaternionf.hashCode();
            return result;
        }
    }
}

